DROP VIEW public.v_rc_cli_conv_pbm;
DROP VIEW public.v_pdv_rc_cli;
DROP VIEW public.v_pdv_vd_rc_cli_conv;
DROP VIEW public.v_rc_cli;
DROP VIEW public.v_orcamento_pbm;
--DROP VIEW public.v_dsync_pdv_vd_it_pbm;
DROP VIEW public.v_cupomfiscal_pbm;



CREATE OR REPLACE FUNCTION addcolumn() 
RETURNS void AS 
$body$ 
BEGIN 
    
    IF  NOT EXISTS (select 1 
					  from information_schema.columns 
                     where table_name= 'rc_cli' 
                       and column_name='rot_conv_ext') then 
		   

		alter table rc_cli alter column rot_conv_ext type integer;
        
		raise notice 'operacao realizada com sucesso.';
    else 
		raise notice 'coluna existe.'; 
    end if; 
      
end; 
-- fim bloco principal 
$body$ 
language plpgsql volatile 
  cost 100; 
alter function addcolumn() owner to postgres; 
select addcolumn(); 
drop function addcolumn();



CREATE OR REPLACE VIEW public.v_rc_cli_conv_pbm AS
 SELECT rc_cli.cd_emp,
    rc_cli.cd_cli,
    rc_cli.rz_cli,
    rc_cli.nm_fant,
    rc_cli_conv.cd_conv,
    rc_cli_conv.ds_conv,
    rc_cli.rot_conv_ext
   FROM rc_cli
     LEFT JOIN rc_cli_conv ON rc_cli.cd_conv = rc_cli_conv.cd_conv AND rc_cli.cd_emp = rc_cli_conv.cd_emp
  WHERE rc_cli.sts_cli = 0::numeric AND rc_cli.rot_conv_ext::numeric > 0::numeric;

ALTER TABLE public.v_rc_cli_conv_pbm
    OWNER TO postgres;



CREATE OR REPLACE VIEW public.v_pdv_rc_cli AS
 SELECT rc_cli.cd_emp,
    rc_cli.cd_cli,
    rc_cli.rz_cli,
    rc_cli.end_cli,
    COALESCE(rc_cli.numero, '0'::character varying) AS numero,
    rc_cli.bairro,
    rc_cli.ddd_tel,
    rc_cli.tel,
    rc_cli.cep,
    COALESCE(glb_cid.ds_cid, 'NAO INFORMADA'::character varying) AS ds_cid,
    COALESCE(glb_cid.uf, 'SN'::character varying) AS uf,
    COALESCE(glb_cid.cd_cid, 0::numeric) AS cd_cid,
    rc_cli.nm_fant,
    rc_cli.cgc_cpf,
    rc_cli_conv.ds_conv,
    COALESCE(rc_cli.esp_cli, 0::numeric) AS esp_cli,
    COALESCE(rc_cli.matricula, '0'::character varying) AS matricula,
    rc_cli.vlr_cred,
    COALESCE(rc_cli.sts_cred, 0::numeric) AS sts_cred,
    COALESCE(rc_cli_conv.sts_cred::integer, 0) AS sts_cred_conv,
        CASE
            WHEN rc_cli.sts_cred = 1::numeric THEN 'BLOQUEADO'::text
            ELSE 'LIBERADO'::text
        END AS ds_sts_cred_conveniado,
        CASE
            WHEN COALESCE(rc_cli_conv.sts_cred::integer, 0) = 1 THEN 'BLOQUEADO'::text
            ELSE 'LIBERADO'::text
        END AS ds_sts_cred_convenio,
    COALESCE(rc_cli_conv.conv_habilitado, 0) AS conv_habilitado,
    COALESCE(rc_cli_conv.flag_recbto_vlr_subsidio, 0::numeric) AS flag_recbto_vlr_subsidio,
    COALESCE(rc_cli.vlr_deb, 0::numeric) AS vlr_deb,
    COALESCE(rc_cli_conv.perc_desc, 0::numeric) AS perc_desc,
    COALESCE(rc_cli_conv.cd_conv, 0::numeric) AS cd_conv,
    COALESCE(rc_cli.sts_cli, 0::numeric) AS sts_cli,
    COALESCE(rc_cli_conv.tp_conv, 0::numeric) AS tp_conv,
    COALESCE(rc_cli.cons_final, 0::numeric) AS cons_final,
    COALESCE(rc_cli.tp_cons_final, 0::numeric) AS tp_cons_final,
    rc_cli_conv.instrucoes,
    COALESCE(rc_cli_conv.flag_requer_senha, 0::numeric) AS flag_requer_senha,
    rc_cli.senha,
    COALESCE(rc_cli.rot_conv_ext::numeric, 0::numeric) AS rot_conv_ext,
    COALESCE(rc_cli_conv.perc_rec_min_conv, 0::numeric) AS perc_rec_min_conv,
    COALESCE(rc_cli_conv.perc_rec_max_conv, 0::numeric) AS perc_rec_max_conv,
    COALESCE(rc_cli.perc_rec_min_conv, 0::numeric) AS perc_rec_min_conveniado,
    COALESCE(rc_cli.perc_rec_max_conv, 0::numeric) AS perc_rec_max_conveniado,
    COALESCE(rc_cli_conv.qt_max_parc, 0) AS qt_max_parc,
    COALESCE(rc_cli_conv.vlr_min_parc, 0::numeric) AS vlr_min_parc,
    COALESCE(rc_cli.vlr_cred, 0::numeric) - COALESCE(rc_cli.vlr_deb, 0::numeric) AS vlr_saldo
   FROM rc_cli
     LEFT JOIN rc_cli_conv ON rc_cli.cd_emp = rc_cli_conv.cd_emp AND rc_cli.cd_conv = rc_cli_conv.cd_conv
     LEFT JOIN glb_cid ON rc_cli.cd_cid = glb_cid.cd_cid;

ALTER TABLE public.v_pdv_rc_cli
    OWNER TO postgres;



CREATE OR REPLACE VIEW public.v_pdv_vd_rc_cli_conv AS
 SELECT rc_cli.cd_emp,
    rc_cli.cd_cli,
    rc_cli.rz_cli,
    rc_cli.nm_fant,
    rc_cli.cgc_cpf,
    rc_cli_conv.ds_conv,
    rc_cli_conv.flag_somente_desc_contrato,
    COALESCE(rc_cli.esp_cli, 0::numeric) AS esp_cli,
    COALESCE(rc_cli_conv_rc_cli.matricula, ''::character varying) AS matricula,
    COALESCE(rc_cli.exige_senha_compra::numeric, 0::numeric) AS exige_senha_compra,
        CASE
            WHEN rc_cli_conv_rc_cli.sts_cred::numeric = 1::numeric THEN 'bloqueado'::text
            ELSE 'liberado'::text
        END AS sts_cred_conveniado,
        CASE
            WHEN rc_cli.sts_cred = 0::numeric THEN
            CASE
                WHEN rc_cli_conv.conv_habilitado::numeric = 1::numeric THEN 'bloqueado'::text
                ELSE 'liberado'::text
            END
            ELSE
            CASE
                WHEN rc_cli.sts_cred = 1::numeric THEN 'bloqueado'::text
                ELSE 'liberado'::text
            END
        END AS sts_cred_convenio,
    rc_cli_conv.perc_desc,
    rc_cli_conv_rc_cli.cd_conv,
    rc_cli_conv_rc_cli.sts_ativo AS sts_cli,
    rc_cli_conv.tp_conv,
    rc_cli.cons_final,
    rc_cli_conv.instrucoes,
    COALESCE(rc_cli_conv.flag_requer_senha, 0::numeric) AS flag_requer_senha,
    COALESCE(rc_cli.senha, ''::character varying) AS senha,
    COALESCE(rc_cli.rot_conv_ext::numeric, 0::numeric) AS rot_conv_ext,
    COALESCE(rc_cli_conv.perc_rec_min_conv, 0::numeric) AS perc_rec_min_conv,
    COALESCE(rc_cli_conv.perc_rec_max_conv, 0::numeric) AS perc_rec_max_conv,
    COALESCE(rc_cli_conv_rc_cli.perc_rec_min_conv, 0::numeric::double precision) AS perc_rec_min_conveniado,
    COALESCE(rc_cli_conv_rc_cli.perc_rec_max_conv, 0::numeric::double precision) AS perc_rec_max_conveniado,
    COALESCE(rc_cli_conv.qt_max_parc, 0) AS qt_max_parc,
    COALESCE(rc_cli_conv.vlr_min_parc, 0::numeric) AS vlr_min_parc,
    COALESCE(rc_cli_conv.qtd_dias_prorrog::numeric, 0::numeric) AS qtd_dias_prorrog,
    COALESCE(rc_cli_conv.dia_fat, 0::numeric) AS dia_fat,
        CASE COALESCE(titular.flag_dependente_comp_limite_titular, 0::numeric)
            WHEN 1 THEN COALESCE(conv_titular.vlr_cred, 0.00::double precision)
            ELSE COALESCE(rc_cli_conv_rc_cli.vlr_cred, 0.00::double precision)
        END AS vlr_cred,
        CASE COALESCE(titular.flag_dependente_comp_limite_titular, 0::numeric)
            WHEN 1 THEN COALESCE(conv_titular.vlr_deb, 0.00::double precision)
            ELSE COALESCE(rc_cli_conv_rc_cli.vlr_deb, 0.00::double precision)
        END AS vlr_deb,
        CASE COALESCE(titular.flag_dependente_comp_limite_titular, 0::numeric)
            WHEN 1 THEN COALESCE(conv_titular.vlr_deb_futuro, 0.00::double precision)
            ELSE COALESCE(rc_cli_conv_rc_cli.vlr_deb_futuro, 0.00::double precision)
        END AS vlr_deb_futuro,
    COALESCE(titular.flag_dependente_comp_limite_titular, 0::numeric) AS flag_dependente_comp_limite_titular,
        CASE COALESCE(depende.cd_cli_titular, 0)
            WHEN 0 THEN 0
            ELSE 1
        END AS ehdependente,
    COALESCE(depende.cd_cli_titular, 0) AS cd_cli_titular
   FROM rc_cli
     LEFT JOIN rc_cli_conv_rc_cli ON rc_cli.cd_cli = rc_cli_conv_rc_cli.cd_cli::numeric AND rc_cli.cd_emp = rc_cli_conv_rc_cli.cd_emp::numeric
     LEFT JOIN rc_cli_conv ON rc_cli_conv_rc_cli.cd_conv::numeric = rc_cli_conv.cd_conv AND rc_cli.cd_emp = rc_cli_conv.cd_emp
     LEFT JOIN rc_cli_conv_dependente depende ON rc_cli.cd_conv = depende.cd_conv::numeric AND rc_cli.cd_cli = depende.cd_cli_depend::numeric
     LEFT JOIN rc_cli titular ON depende.cd_conv::numeric = titular.cd_conv AND depende.cd_cli_titular::numeric = titular.cd_cli
     LEFT JOIN rc_cli_conv_rc_cli conv_titular ON titular.cd_cli = conv_titular.cd_cli::numeric AND titular.cd_emp = conv_titular.cd_emp::numeric
  WHERE rc_cli.sts_cli = 0::numeric;

ALTER TABLE public.v_pdv_vd_rc_cli_conv
    OWNER TO postgres;



CREATE OR REPLACE VIEW public.v_rc_cli AS
 SELECT rc_cli.cd_emp,
    rc_cli.cd_cli,
    rc_cli.rz_cli,
    rc_cli.cgc_cpf,
    rc_cli.esp_cli,
    rc_cli.matricula,
    rc_cli.vlr_cred,
    rc_cli.vlr_deb,
    rc_cli.sts_cli,
    rc_cli.sts_cred,
    rc_cli.cons_final,
    rc_cli.senha,
    rc_cli.rot_conv_ext,
    rc_cli_fideli_cartao.nr_cartao
   FROM rc_cli
     LEFT JOIN rc_cli_fideli_cartao ON rc_cli.cd_emp = rc_cli_fideli_cartao.cd_emp::numeric AND rc_cli.cd_cli = rc_cli_fideli_cartao.cd_cli::numeric
     LEFT JOIN rc_cli_conv_rc_cli ON rc_cli.cd_emp = rc_cli_conv_rc_cli.cd_emp::numeric AND rc_cli.cd_cli = rc_cli_conv_rc_cli.cd_cli::numeric
     LEFT JOIN rc_cli_conv ON rc_cli_conv_rc_cli.cd_emp::numeric = rc_cli_conv.cd_emp AND rc_cli_conv_rc_cli.cd_conv::numeric = rc_cli_conv.cd_conv;

ALTER TABLE public.v_rc_cli
    OWNER TO postgres;



CREATE OR REPLACE VIEW public.v_orcamento_pbm AS
 SELECT orc.cd_emp,
    orc.cd_filial,
    orc.cd_orc,
    orc.dt_emi,
    orc.hr_emi,
    orc.nr_ped_televd AS nr_pedido,
    conv.cd_conv,
    conv.ds_conv AS nm_conv,
    conv.cd_cli AS cd_cli_conv,
    cli.rz_cli AS nm_cli_conv,
    orc.tipo_pbm,
    orc.modalidade_pbm,
    orc.cd_projeto_pbm,
    orc.dt_receita_pbm,
    orc.cpf_cli_pbm,
    orc.nr_cartao_pbm,
    orc.cd_dependente_pbm,
    orc.nr_rg_dependente_pbm,
    orc.usu_nm_farm_popular AS farm_popular_usu,
    orc.usu_sh_farm_popular AS farm_popular_senha,
    COALESCE(NULLIF(cpl.nr_autr_pbm_item::text, '0'::text), orc.nr_autr_pbm::text) AS nr_autr_pbm,
    cpl.cd_prod,
    prod.ds_prod,
    cpl.vlr_pbm AS vlr_prod_reembolso,
    cpl.qt_aut_pbm,
    cpl.vlr_it_autr_pbm,
    cpl.vlr_desc_autr_pbm,
    cpl.vlr_cliente AS vlr_prod_cli
   FROM est_orc orc
     JOIN rc_cli cli ON orc.cd_emp = cli.cd_emp AND orc.tipo_pbm = cli.rot_conv_ext::numeric
     JOIN rc_cli_conv conv ON cli.cd_emp = conv.cd_emp AND cli.cd_cli = conv.cd_cli AND conv.tp_conv = 2::numeric
     JOIN est_orc_cpl cpl ON orc.cd_emp = cpl.cd_emp AND orc.cd_filial = cpl.cd_filial AND orc.cd_orc = cpl.cd_orc
     LEFT JOIN est_prod prod ON cpl.cd_emp = prod.cd_emp AND cpl.cd_prod = prod.cd_prod
  WHERE orc.tipo_pbm > 0::numeric;

ALTER TABLE public.v_orcamento_pbm
    OWNER TO postgres;



CREATE OR REPLACE VIEW public.v_cupomfiscal_pbm AS
 SELECT vd.cd_emp,
    vd.cd_filial,
    vd.dt_vd,
    vd.dt_cad,
    vd.cd_cx,
    vd.cd_vd,
    vd.nr_ecf,
    vd.st_vd,
    vd.cd_conv,
        CASE
            WHEN vd.tipo_pbm::numeric > 0::numeric THEN
            CASE
                WHEN vd.cd_cli_pbm = 0::numeric THEN ( SELECT rc_cli.cd_cli
                   FROM rc_cli
                  WHERE rc_cli.rot_conv_ext::numeric = vd.tipo_pbm::numeric AND rc_cli.sts_cli = 0::numeric
                 LIMIT 1)
                ELSE vd.cd_cli_pbm
            END
            ELSE vd.cd_cli
        END AS cd_cli_conv,
    NULL::character varying AS cgc_conv,
    vd.tipo_pbm,
        CASE vd.tipo_pbm
            WHEN 1 THEN 'prevsaude'::character varying
            WHEN 2 THEN 'vida-link'::character varying
            WHEN 3 THEN 'e-pharma'::character varying
            WHEN 4 THEN 'transaction center'::character varying
            WHEN 5 THEN 'farmacia popular'::character varying
            WHEN 6 THEN 'funcional card'::character varying
            ELSE 'outros'::character varying
        END AS nm_conv,
    vd.vlr_conv_pbm AS vlr_conv,
    COALESCE(it.nr_autorizacao_pbm, it.nr_orc_vd_link) AS cd_autorizacao,
    it.cd_it,
    it.cd_prod,
    it.vlr_avista_pbm AS vlr_prod_cli,
    COALESCE(
        CASE
            WHEN it.vlr_reembol_pbm = 0::numeric THEN NULL::numeric
            ELSE it.vlr_reembol_pbm
        END,
        CASE
            WHEN it.vlr_reembol = 0::numeric THEN NULL::numeric
            ELSE it.vlr_reembol
        END) AS vlr_prod_reembolso,
    it.vlr_conv_pbm AS vlr_prod_conv,
    COALESCE(it.cd_usu_libera_pos_pbm, 0::numeric) AS cd_usu_libera_pos_pbm,
    COALESCE(it.valor_desconto_pos_pbm, 0::numeric) AS valor_desconto_pos_pbm,
    COALESCE(vd.flag_consolidado, 0) AS flag_consolidado
   FROM pdv_vd vd
     JOIN pdv_vd_it it ON vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd
  WHERE vd.st_vd > '-1'::integer::numeric AND vd.tipo_pbm > 0 AND (length(it.nr_autorizacao_pbm::text) > 1 OR length(it.nr_orc_vd_link::text) > 1);

ALTER TABLE public.v_cupomfiscal_pbm
    OWNER TO postgres;

